<?php
/* --------------------------------------------------------------
   ApiCollectionMetaData.php 2020-02-20
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Api\Application\Responses\Interfaces;

use JsonSerializable;

/**
 * Interface ApiCollectionMetaData
 *
 * @package Gambio\Api\Application\Responses\Interfaces
 */
interface ApiMetaData extends JsonSerializable
{
    /**
     * @param string $name
     * @param string $link
     *
     * @return $this
     */
    public function setLink(string $name, string $link): self;
}